<?php
  function getCounter()
  {
    if(!file_exists('/var/wwwdata/licznik.txt')){
      //brak pliku licznika
      return false;
    }
    if(!$fd = fopen('/var/wwwdata/licznik.txt', "r+")){
      //brak dostępu do pliku licznika
      return false;
    }
    if(!flock($fd, LOCK_EX)){
      //nie uzyskano blokady
      fclose($fd);
      return false;
    }
    $count = fgets($fd);
    if(is_numeric($count)){
      $result = (int) ($count + 1);
      fseek($fd, 0);
      fputs($fd, $result);
    }
    else{
      //nieprawidłowy format odczytanych danych
      $result = false;
    }
    flock($fd, LOCK_UN);
    fclose($fd);
    return $result;
  }
?>
